document.addEventListener('DOMContentLoaded', function () {
    // Get all pins
    const pins = document.querySelectorAll('.pin-all');

    // Add click event listener to each pin
    pins.forEach(pin => {
        pin.addEventListener('click', function (e) {
            // Remove active class from all pins
            pins.forEach(p => p.classList.remove('active'));
            pins.forEach(p => p.style.opacity = 0);

            // Add active class to clicked pin
            this.classList.add('active');
            this.style.opacity = 1;

            // Stop event from propagating to document
            e.stopPropagation();
        });
    });

    // Close tooltip when clicking outside
    document.addEventListener('click', function () {
        pins.forEach(pin => pin.classList.remove('active'));
        pins.forEach(p => p.style.opacity = 1);
    });
});

